﻿namespace Hims.Api.Controllers
{
    using System.Threading.Tasks;
    using Domain.Services;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Shared.UserModels.Filters;
    using Utilities;

    /// <inheritdoc />
    /// <summary>
    ///  Validators Controller
    /// </summary>
    [Route("api/validate")]
    [Consumes("application/json")]
    [Produces("application/json")]
    [AllowAnonymous]
    public class ValidatorsController : BaseController
    {
        /// <summary>
        /// Validator Services
        /// </summary>
        private readonly IValidatorService validatorServices;

        /// <inheritdoc />
        public ValidatorsController(IValidatorService validatorServices) => this.validatorServices = validatorServices;

        /// <summary>
        /// The validate email.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The boolean whether exist or not <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - Exist.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [ProducesResponseType(typeof(bool), 200)]
        [ProducesResponseType(500)]
        [HttpPost]
        [Route("email")]
        public async Task<ActionResult> ValidateEmailAsync([FromBody] ValidatorFilterModel model)
        {
            var count = await this.validatorServices.ValidateEmailAsync(model.Query, model.Type, model.ReferenceId);
            return this.Success(count > 0);
        }

        /// <summary>
        /// The validate mobile.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The boolean whether exist or not <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - Exist.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [ProducesResponseType(typeof(bool), 200)]
        [ProducesResponseType(500)]
        [HttpPost]
        [Route("mobile")]
        public async Task<ActionResult> ValidateMobileAsync([FromBody] ValidatorFilterModel model)
        {
            var count = await this.validatorServices.ValidateMobileAsync(model.Query, model.CountryId, model.Type, model.ReferenceId);
            return this.Success(count > 0);
        }

        /// <summary>
        /// The validate NPI.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The boolean whether exist or not <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - Exist.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [ProducesResponseType(typeof(bool), 200)]
        [ProducesResponseType(500)]
        [HttpPost]
        [Route("npi")]
        public async Task<ActionResult> ValidateNpiAsync([FromBody] ValidatorFilterModel model)
        {
            var count = await this.validatorServices.ValidateNpiAsync(model.Query, model.ReferenceId);
            return this.Success(count > 0);
        }

        /// <summary>
        /// The validate pharmacy product async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The boolean whether exist or not <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - Exist.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [ProducesResponseType(typeof(bool), 200)]
        [ProducesResponseType(500)]
        [HttpPost]
        [Route("pharmacy-product")]
        public async Task<ActionResult> ValidatePharmacyProducAsync([FromBody] ValidatorFilterModel model)
        {
            if (model == null)
            {
                return this.Success(false);
            }
            if (model != null && string.IsNullOrEmpty(model.Query))
            {
                return this.Success(false);
            }
            var count = await this.validatorServices.ValidatePharmacyProductAsync(model.Query, model.PharmacyProductId);
            return this.Success(count > 0);
        }

        /// <summary>
        /// The Validate Name Async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        [ProducesResponseType(typeof(bool), 200)]
        [ProducesResponseType(500)]
        [HttpPost]
        [Route("username")]
        public async Task<ActionResult> ValidateUserNameAsync([FromBody] ValidatorFilterModel model)
        {
            var count = await this.validatorServices.ValidateUserNameAsync(model.Query, model.Type, model.ReferenceId);
            return this.Success(count > 0);
        }
    }
}